<?php include("cabecera.php") ?>
<?php include("conexion.php") ?>

<?php
date_default_timezone_set('America/Bogota');

$objConexion = new conexion();

// Obtener listado de productos desde la tabla `productos`
$productos = $objConexion->consultar("SELECT * FROM productos ORDER BY nombre ASC");

// Procesar formulario si se envi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fecha    = $_POST['fecha'] ?? '';
    $nombre   = $_POST['nombre'] ?? '';
    $nombre2  = $_POST['nombre2'] ?? '';
    $tamano   = $_POST['tamano'] ?? '';
    $cantidad = (int)($_POST['cantidad'] ?? 0);

    if ($nombre && $tamano && $cantidad > 0 && $fecha) {
        $sql = "INSERT INTO ventas (nombre, nombre2, tamano, cantidad, fecha) VALUES ('$nombre', '$nombre2', '$tamano', '$cantidad', '$fecha')";
        $objConexion->ejecutar($sql);
    }

    header("location:insertar_ventas2.php");
    exit;
}

// Consultar ventas existentes
$ventas = $objConexion->consultar("SELECT * FROM ventas ORDER BY id DESC");
?>

<br><br>

<div class="container">
    <div class="row">
        <div class="col-md-6">

            <div class="card">
                <div class="card-header">Datos del producto vendido</div>
                <div class="card-body">

                    <form action="insertar_ventas2.php" method="post" enctype="multipart/form-data">

                        <label>Producto principal:</label>
                        <select name="nombre" class="form-control" required>
                            <option selected disabled>Seleccione producto</option>
                            <?php foreach ($productos as $producto) { ?>
                                <option value="<?php echo $producto['nombre']; ?>"><?php echo $producto['nombre']; ?></option>
                            <?php } ?>
                        </select>
                        <br>


                        <label>Tamano:</label>
                        <select name="tamano" class="form-control" required>
                            <option selected disabled>Seleccione tamano</option>
                            <option value="personal">Personal</option>
                            <option value="mediano">Mediano</option>
                            <option value="grande">Grande</option>
                        </select>
                        <br>

                        <label>Cantidad:</label>
                        <input class="form-control" type="number" name="cantidad" value="1" min="1" required>
                        <br>

                        <label>Fecha y Hora:</label>
                        <input class="form-control" type="datetime-local" name="fecha" value="<?php echo date("Y-m-d\TH:i"); ?>" required>
                        <br>

                        <input class="btn btn-success" type="submit" value="Enviar venta">

                    </form>

                </div>
            </div>

        </div>

        <div class="col-md-6">

            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Productos</th>
                        <th>Tamano</th>
                        <th>Cantidad</th>
                        <th>Fecha</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ventas as $venta) { ?>
                        <tr>
                            <td><?php echo $venta['id']; ?></td>
                            <td><?php echo $venta['nombre'] . ' / ' . $venta['nombre2']; ?></td>
                            <td><?php echo $venta['tamano']; ?></td>
                            <td><?php echo $venta['cantidad']; ?></td>
                            <td><?php echo $venta['fecha']; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

        </div>
    </div>
</div>

<?php include("pie.php") ?>
