<?php include("cabecera.php") ?> 
<?php include("conexion.php") ?>

<?php
date_default_timezone_set('America/Bogota');

$objConexion = new conexion();

// Obtener listado de productos
$productos = $objConexion->consultar("SELECT * FROM productos ORDER BY nombre ASC");

// Procesar formulario si se envió
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fecha    = $_POST['fecha'] ?? '';
    $nombre   = $_POST['nombre'] ?? '';
    $tamano   = $_POST['tamano'] ?? '';
    $cantidad = (int)($_POST['cantidad'] ?? 0);

    if ($nombre && $tamano && $cantidad > 0 && $fecha) {
        $sql = "INSERT INTO ventas (nombre, tamano, cantidad, fecha) VALUES ('$nombre', '$tamano', '$cantidad', '$fecha')";
        $objConexion->ejecutar($sql);
    }

    header("location:insertar_ventas.php");
    exit;
}

// Consultar ventas existentes
$ventas = $objConexion->consultar("SELECT * FROM ventas ORDER BY id DESC");
?>

<br><br>

<div class="container">
    <div class="row">
        <div class="col-md-6">

            <div class="card">
                <div class="card-header">Datos del producto vendido</div>
                <div class="card-body">

                    <form action="insertar_ventas.php" method="post" enctype="multipart/form-data">

                        <!-- Campo para ingresar el ID -->
                        <label for="producto_id">ID del producto:</label>
                        <input type="number" id="producto_id" class="form-control" placeholder="Ej: 101" required>

                        <!-- Campo para mostrar el nombre automáticamente -->
                        <label for="nombre_producto" class="mt-2">Nombre del producto:</label>
                        <input type="text" id="nombre_producto" class="form-control" readonly>

                        <!-- Campo oculto para enviar el nombre real al backend -->
                        <input type="hidden" name="nombre" id="nombre_hidden">

                        <br>

                        <label>Tamaño:</label>
                        <select name="tamano" class="form-control" required>
                            <option selected disabled>Seleccione tamaño</option>
                            <option value="personal">Personal</option>
                            <option value="mediano">Mediano</option>
                            <option value="grande">Grande</option>
                        </select>
                        <br>

                        <label>Cantidad:</label>
                        <input class="form-control" type="number" name="cantidad" value="1" min="1" required>
                        <br>

                        <label>Fecha y Hora:</label>
                        <input class="form-control" type="datetime-local" name="fecha" value="<?php echo date("Y-m-d\TH:i"); ?>" required>
                        <br>

                        <input class="btn btn-success" type="submit" value="Enviar venta">

                    </form>

                </div>
            </div>

        </div>

        <div class="col-md-6">

            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Producto</th>
                        <th>Tamaño</th>
                        <th>Cantidad</th>
                        <th>Fecha</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ventas as $venta) { ?>
                        <tr>
                            <td><?php echo $venta['id']; ?></td>
                            <td><?php echo $venta['nombre']; ?></td>
                            <td><?php echo $venta['tamano']; ?></td>
                            <td><?php echo $venta['cantidad']; ?></td>
                            <td><?php echo $venta['fecha']; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

        </div>
    </div>
</div>

<!-- Script para mapear ID a nombre -->
<script>
// Convertimos el array PHP en un arreglo JS
const productos = <?php echo json_encode($productos); ?>;

// Escuchar cambios en el input del ID
document.getElementById('producto_id').addEventListener('input', function() {
    const idIngresado = parseInt(this.value);
    const producto = productos.find(p => p.id == idIngresado);

    // Mostrar nombre o limpiar si no existe
    if (producto) {
        document.getElementById('nombre_producto').value = producto.nombre;
        document.getElementById('nombre_hidden').value = producto.nombre;
    } else {
        document.getElementById('nombre_producto').value = '';
        document.getElementById('nombre_hidden').value = '';
    }
});
</script>

<?php include("pie.php") ?>
