<?php include("cabecera_admin.php")?>
<?php include("conexion.php")?>

<?php

$objConexion = new conexion();

// Verificamos si se ha enviado una fecha desde el formulario
$fechaSeleccionada = isset($_POST['fecha']) ? $_POST['fecha'] : '';

// Si hay una fecha seleccionada, filtramos los resultados por esa fecha
if ($fechaSeleccionada) {
    $cantidadingredientes = $objConexion->consultar("
        SELECT cantidadingredientes.id, ingredientes.nombre AS nombre_ingrediente, cantidadingredientes.cantidad, cantidadingredientes.fecha
        FROM cantidadingredientes
        JOIN ingredientes ON cantidadingredientes.id_cantidad = ingredientes.id
        WHERE DATE(cantidadingredientes.fecha) = '$fechaSeleccionada'
        ORDER BY cantidadingredientes.fecha DESC, cantidadingredientes.id DESC
    ");
} else {
    // Si no hay fecha seleccionada, mostramos todos los registros
    $cantidadingredientes = $objConexion->consultar("
        SELECT cantidadingredientes.id, ingredientes.nombre AS nombre_ingrediente, cantidadingredientes.cantidad, cantidadingredientes.fecha
        FROM cantidadingredientes
        JOIN ingredientes ON cantidadingredientes.id_cantidad = ingredientes.id
        ORDER BY cantidadingredientes.fecha DESC, cantidadingredientes.id DESC
    ");
}

?>

<br/>
<br/>

<div class="col-md-6">
    <!-- Formulario para seleccionar la fecha -->
    <form method="post" action="">
        <label for="fecha">Seleccionar Fecha:</label>
        <input type="date" id="fecha" name="fecha" value="<?php echo $fechaSeleccionada; ?>">
        <button type="submit" class="btn btn-primary">Filtrar</button>
    </form>
    <br/>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Ingrediente</th>
                <th>Cantidad</th>
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            <?php if(!empty($cantidadingredientes)): ?>
                <?php foreach($cantidadingredientes as $cantidad){ ?>
                    <tr>
                        <td><?php echo $cantidad['id']; ?></td>
                        <td><?php echo $cantidad['nombre_ingrediente']; ?></td>
                        <td><?php echo $cantidad['cantidad']; ?></td>
                        <td><?php echo date("Y-m-d", strtotime($cantidad['fecha'])); ?></td>
                    </tr>
                <?php } ?>
            <?php else: ?>
                <tr>
                    <td colspan="4">No hay datos para la fecha seleccionada.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include("pie.php")?>
