<?php include("cabecera.php"); ?>
<?php include("conexion.php"); ?>

<?php
date_default_timezone_set('America/Bogota');

if ($_POST) {
    $objConexion = new conexion();
    
    foreach ($_POST['cantidad'] as $id_ingrediente => $cantidad) {
        $fecha = $_POST['fecha'][$id_ingrediente];

        // Validaciones
        if (!is_numeric($cantidad) || $cantidad <= 0) {
            continue; // Si la cantidad no es válida, la ignora
        }

        // Inserción segura con prepared statements para prevenir SQL Injection
        $sql = "INSERT INTO `cantidadingredientes` (`id`, `id_ingrediente`, `cantidad`, `fecha`) VALUES (NULL, ?, ?, ?)";
        $stmt = $objConexion->getConexion()->prepare($sql);
        $stmt->bind_param("iis", $id_ingrediente, $cantidad, $fecha);
        $stmt->execute();
    }

    header("location:insertar_inventario_orden_nombre.php?status=success");
    exit();
}

// Obtener ingredientes ordenados alfabéticamente
$objConexion = new conexion();
$ingredientes = $objConexion->consultar("SELECT * FROM ingredientes ORDER BY nombre ASC");

?>

<br/>
<br/>

<?php if (isset($_GET['status']) && $_GET['status'] == 'success') { ?>
    <div class="alert alert-success" role="alert">
        Los datos fueron enviados correctamente!
    </div>
<?php } ?>

<div class="card">
    <table class="table">
        <thead>
            <tr>
                <th>Ingrediente</th>
                <th>Cantidad</th>
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            <form action="insertar_inventario_orden_nombre.php" method="post" enctype="multipart/form-data">  
                <?php foreach ($ingredientes as $fila) { ?>
                    <tr>
                        <td><?php echo htmlspecialchars($fila['nombre']); ?></td>
                        <td><input class="form-control" type="number" name="cantidad[<?php echo $fila['id']; ?>]" min="1" required></td>
                        <td><input class="form-control" type="datetime-local" name="fecha[<?php echo $fila['id']; ?>]" value="<?php echo date("Y-m-d\TH:i"); ?>" required></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="3"><input class="btn btn-success" type="submit" value="Enviar cantidad"></td>
                </tr>
            </form>
        </tbody>
    </table>
</div>

<?php include("pie.php"); ?>
