<?php include("cabecera_admin.php")?>
<?php include("conexion.php")?>

<?php

$objConexion = new conexion();

// Consulta para obtener las cantidades de ingredientes para diferentes fechas
$cantidadingredientes = $objConexion->consultar("
    SELECT ingredientes.nombre AS nombre_ingrediente, cantidadingredientes.cantidad, DATE(cantidadingredientes.fecha) AS fecha
    FROM cantidadingredientes
    JOIN ingredientes ON cantidadingredientes.id_cantidad = ingredientes.id
    ORDER BY ingredientes.nombre, cantidadingredientes.fecha
");

// Reestructuramos los datos para que cada fecha sea una columna
$ingredientes = [];
$fechas = [];

foreach ($cantidadingredientes as $cantidad) {
    $nombre_ingrediente = $cantidad['nombre_ingrediente'];
    $fecha = $cantidad['fecha'];
    $cantidad_valor = $cantidad['cantidad'];

    // Guardamos la fecha en un array para generar las columnas
    if (!in_array($fecha, $fechas)) {
        $fechas[] = $fecha;
    }

    // Organizamos las cantidades por ingrediente y fecha
    $ingredientes[$nombre_ingrediente][$fecha] = $cantidad_valor;
}

?>

<br/>
<br/>

<div class="col-md-10">
    <h3>Cantidades de ingredientes por fecha</h3>

    <table class="table">
        <thead>
            <tr>
                <th>Ingrediente</th>
                <?php foreach ($fechas as $fecha): ?>
                    <th><?php echo $fecha; ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($ingredientes as $nombre_ingrediente => $cantidades_por_fecha): ?>
                <tr>
                    <td><?php echo $nombre_ingrediente; ?></td>
                    <?php foreach ($fechas as $fecha): ?>
                        <td><?php echo isset($cantidades_por_fecha[$fecha]) ? $cantidades_por_fecha[$fecha] : '-'; ?></td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include("pie.php")?>
